// MeasPulseWidthDlg.cpp : implementation file
//

#include "stdafx.h"
#include "MeasPulseWidth.h"
#include "MeasPulseWidthDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMeasPulseWidthDlg dialog

CMeasPulseWidthDlg::CMeasPulseWidthDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMeasPulseWidthDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMeasPulseWidthDlg)
	m_Status = _T("");
	m_time = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMeasPulseWidthDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMeasPulseWidthDlg)
	DDX_Control(pDX, IDC_ENABLE, m_enable);
	DDX_Text(pDX, IDC_STATUS, m_Status);
	DDX_Text(pDX, IDC_PULSEWIDTH, m_time);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMeasPulseWidthDlg, CDialog)
	//{{AFX_MSG_MAP(CMeasPulseWidthDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_OPEN_DRIVER, OnOpenDriver)
	ON_BN_CLICKED(IDC_ENABLE, OnEnable)
	ON_BN_CLICKED(IDC_CLOSE, OnClose)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMeasPulseWidthDlg message handlers

BOOL CMeasPulseWidthDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	// set our SR structures to NULL
	m_pSR=NULL;
    m_driverInstance=NULL;
	m_pPORTD=NULL;
    m_driverInstance1=NULL;
	m_pSqWave=NULL;
    m_driverInstance2=NULL;

	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMeasPulseWidthDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMeasPulseWidthDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMeasPulseWidthDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CMeasPulseWidthDlg::OnOpenDriver() 
{
	/*
  This example was written in MSVC++ 6.0 Standard Edition
  in Win2K SP1 with 3140-850A02 DriverLINX driver for KPCI-3140.

  
  This example shows how measure the duration of a pulse.  It makes use
  of two CT channels and the edge detection feature of 
  digital Port D of the KPCI-3140.


  In general, pulse width is determined by connecting the unknown pulse
  to the gate of a counter.  This counter is programmed for GATED Event
  counting.  How many counts of the known timebase occur during the 
  applied unknown gating pulse is an indication of the pulse width.

  Counter/timer tasks pose a challenge to know when they are completed.  The
  KPCI-3140 has a special feature of being able to send the application notificaiton
  when a change of state occurs at a bit of digital port D.  This feature will be used
  to know when the unknown pulse has completed.

  We are assuming the pulse is active high, so a falling edge at bit0 of Port D
  means the pulse is completed and it is time to read the counter.

  This example requires the use of Windows messaging to intercept
  the TimerTic messages from DriverLINX which will indicate to the 
  application that an edge has occured.  

  Three Service Requests are used :

  - one to generate a square wave signal that can be used as a timebase.  the internal
    timebase of the KPCI-3140 is 40MHz which is often too fast.  the first SR will divide this
	40MHz internal timebase down to a slower rate such as 10KHz.

  - one to measure the pulse duration.  the signal of interest will be connect to the gate
    of this channel, and it will use the squarewave from above as it's timebase

  - one to send this application a message when bit0 of PortD sees a falling edge.  If the pulse
    of interest is active high, a high to low transition means the pules is complete and it is
	time to read the counter.

*/

	   // Open the driver and Initialize the hardware

// pass in driver name to avoid the Open DriverLINX Dialog
m_driverInstance=OpenDriverLINX(m_hWnd,"kpci3140"); //Open DriverLINX driver, and bring up the dialog box to pick a driver
m_pSR=(DL_ServiceRequest*) new (DL_ServiceRequest); //get a pointer to the service request
memset(m_pSR,0,sizeof(DL_ServiceRequest)); //Initialize the members of the service request
DL_SetServiceRequestSize(*m_pSR); //Need to set the service request size member
m_pSR->device=0; //set the device number (DriverLINX Config Panel setting)
m_pSR->operation=INITIALIZE; //Need to initialize the device before we can use it
m_pSR->subsystem=DEVICE;  //the initialize function is part of the DEVICE subsystem
m_pSR->mode=OTHER;  //Initialize is not a polled, interrupt, or dma operation, so we use OTHER
m_pSR->hWnd=m_hWnd;  //Need to set the hWnd member to the window handle of the application
//Execute the initialize service
 //show any errors	

if (DriverLINX(m_pSR) == NoErr)
{
	// success
m_enable.EnableWindow(TRUE);  // enable the Sample button
UpdateData(FALSE);
m_DLmsg=RegisterWindowMessage(DL_MESSAGE);  // get a safe offset for our DriverLINX messages
}
else
{  // problem has occured
showMessage(m_pSR);  // display the error message box

}


// Open the driver and Init the second SR structure:

// pass in driver name to avoid the Open DriverLINX Dialog
m_driverInstance1=OpenDriverLINX(m_hWnd,"kpci3140"); //Open DriverLINX driver, and bring up the dialog box to pick a driver
m_pPORTD=(DL_ServiceRequest*) new (DL_ServiceRequest); //get a pointer to the service request
memset(m_pPORTD,0,sizeof(DL_ServiceRequest)); //Initialize the members of the service request
DL_SetServiceRequestSize(*m_pPORTD); //Need to set the service request size member
m_pPORTD->device=0; //set the device number (DriverLINX Config Panel setting)
m_pPORTD->hWnd=m_hWnd;
// no need to init the same board a second time.....

// Init the third SR
m_driverInstance2=OpenDriverLINX(m_hWnd,"kpci3140"); //Open DriverLINX driver, and bring up the dialog box to pick a driver
m_pSqWave=(DL_ServiceRequest*) new (DL_ServiceRequest); //get a pointer to the service request
memset(m_pSqWave,0,sizeof(DL_ServiceRequest)); //Initialize the members of the service request
DL_SetServiceRequestSize(*m_pSqWave); //Need to set the service request size member
m_pSqWave->device=0; //set the device number (DriverLINX Config Panel setting)
m_pSqWave->hWnd=m_hWnd;


// set focus back to our dialog
CWnd::CenterWindow();
CWnd::SetActiveWindow();		
	
}

void CMeasPulseWidthDlg::OnEnable() 
{
	m_time.Format("%s","measuring...");
	m_Status.Format("%s","Task is armed....");
	m_enable.EnableWindow(FALSE);  // disarm the button until we are done
	UpdateData(FALSE);
	// use CT channel 0 to generate a Square Wave
	m_pSqWave->operation=START;
	m_pSqWave->mode=POLLED;
	m_pSqWave->subsystem=CT;
	m_pSqWave->timing.typeEvent=RATEEVENT;
	m_pSqWave->timing.u.rateEvent.channel=0;
	m_pSqWave->timing.u.rateEvent.mode=SQWAVE;
	m_pSqWave->timing.u.rateEvent.period=Sec2Tics(0,CT,INTERNAL1,0.0001f);  // 10KHz
	DriverLINX(m_pSqWave);  // start the Square Wave
	showMessage(m_pSqWave);

	// enable bit 0 of Port D to detect falling edges
	m_pPORTD->operation=START;
	m_pPORTD->subsystem=CT;
	m_pPORTD->mode=INTERRUPT;
	m_pPORTD->start.typeEvent=COMMAND;
	m_pPORTD->stop.typeEvent= TCEVENT;  //COMMAND; //Remain active until the stop button is pressed
	m_pPORTD->timing.typeEvent=DIEVENT;
	m_pPORTD->timing.u.rateEvent.channel=DI_EXTCLK; //
	m_pPORTD->timing.u.diEvent.mask = 1;  // 1 = bit 0
	m_pPORTD->timing.u.diEvent.match = FALSE;
	m_pPORTD->timing.u.diEvent.pattern = 1;  // 0 for rising edge, 1 for falling edge
	
	DriverLINX(m_pPORTD); //Enable Edge Detection
	showMessage(m_pPORTD); //show any errors

	m_taskID_PORTD=m_pPORTD->taskId; //Need to save the task ID so we can identify it later
	                        // in the TimerTic message

	// use CT channel 1 to measure a pulse width
	m_pSR->mode=POLLED;
	m_pSR->subsystem=CT;
	m_pSR->operation=START;
	m_pSR->timing.typeEvent=RATEEVENT;
	m_pSR->timing.u.rateEvent.channel=1;
	m_pSR->timing.u.rateEvent.clock=TCNm1;  // internal cascade from previous channel
	m_pSR->timing.u.rateEvent.mode=PULSEWD;
	m_pSR->timing.u.rateEvent.pulses=1;
	DriverLINX(m_pSR);
	showMessage(m_pSR);
	
}

void CMeasPulseWidthDlg::OnClose() 
{

		// code to clean up after DriverLINX
            if (m_driverInstance != NULL)
			{
             CloseDriverLINX(m_driverInstance); //close the DriverLINX driver
             m_driverInstance=NULL; //make sure m_driverInstance isn't pointing to anything
			}
            if (m_pSR != NULL)
			{
            delete(m_pSR); //de-allocate the memory used by the service request
            m_pSR=NULL;
			}

         // now do same for the second Service Request:
           if (m_driverInstance1 != NULL)
		   {
            CloseDriverLINX(m_driverInstance1); //close the DriverLINX driver
            m_driverInstance1=NULL; //make sure m_driverInstance isn't pointing to anything
		   }
           if (m_pPORTD != NULL)
		   {
           delete(m_pPORTD); //de-allocate the memory used by the service request
           m_pPORTD=NULL;
		   }

           // now do same for the third Service Request:
           if (m_driverInstance2 != NULL)
		   {
            CloseDriverLINX(m_driverInstance2); //close the DriverLINX driver
            m_driverInstance2=NULL; //make sure m_driverInstance isn't pointing to anything
		   }
           if (m_pSqWave != NULL)
		   {
           delete(m_pSqWave); //de-allocate the memory used by the service request
           m_pSqWave=NULL;
		   }

		   CWnd::DestroyWindow();  // close this application

	
}

void CMeasPulseWidthDlg::showMessage(DL_ServiceRequest *SR)
{
	SR->operation=MESSAGEBOX;
	DriverLINX(SR);
/*
// the code below could be used instead of the messagebox operation above

char errString[100];
DWORD size=50;
int errNumber;
errNumber = getErrCode(SR->result);
// errNumber corresponds to DriverLINX documentation
ReturnMessageString(SR->hWnd,SR->result,errString,size);
// errString corresponds to DriverLINX documentation
m_errMsg.Format("%s",errString);  // would need to add a static text called m_errMsg to dialog
UpdateData(FALSE);  // update the dialog
*/

	return;
}


LRESULT CMeasPulseWidthDlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	// TODO: Add your specialized code here and/or call the base class
	
	// this is the "message pump"
	// need to see if the message is from DriverLINX and then if so
	// which one.  Will decode the info in LPARAM
	if(message == m_DLmsg) //Check for DriverLINX message
	{
		switch(wParam)
		{
		case DL_TIMERTIC: //Check for which task is responsible for this TimerTic message
			WORD taskID;
			float width;
			taskID = getTaskId(lParam);  // this is a DriverLINX macro to decode the info
			if (m_taskID_PORTD == taskID)
			{
			      m_Status.Format("%s","Edge at bit 0 has occurred....");
				  m_enable.EnableWindow(TRUE);
			     
                  // time to read the pulse width counter
				  
				  	m_pSR->operation=STATUS;
                	m_pSR->status.typeStatus=TIMERSTATUS;
	                DriverLINX(m_pSR);
					width = (float) m_pSR->status.u.timerStatus.count/(10000);
					// counts divided by the 10KHz time base
                    m_time.Format("%f",width);
	                UpdateData(FALSE);  //update the dialog
					// disable the pulse width task
					m_pSR->operation=STOP;  // the pulse width task
	                DriverLINX(m_pSR);
					// disable the edge detection task
                   	m_pPORTD->taskId = m_taskID_PORTD;
                    m_pPORTD->operation=STOP;	
                    DriverLINX(m_pPORTD);
					// stop the square wave task....
					m_pSqWave->operation=STOP;  // the square wave task
	                DriverLINX(m_pSqWave);
			} 

			break;
        case DL_SERVICEDONE:
            m_Status.Format("%s","Task is inactive....");
			UpdateData(FALSE); //update the dialog
			break;
		}
	}


	// pass the message along in case it was not from DriverLINX
	return CDialog::WindowProc(message, wParam, lParam);
}
